package com.bizvane.mktcenterservice.models.vo.mktp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class MktpActivityInviteRecordRequestVO {

    // 活动ID
    @NotNull(message = "活动ID[mktpActivityId]不允许为空")
    @ApiModelProperty(name = "mktpActivityId", value = "活动ID", example = "")
    private Long mktpActivityId;

    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty(name = "inviteeExternalName", value = "好友名称/群成员名称", example = "")
    private String inviteeExternalName;

    @ApiModelProperty(name = "inviteeStatus", value = "被邀请人邀请状态 1-邀请成功，2-邀请失败", example = "")
    private Integer inviteeStatus;

    @ApiModelProperty(name = "staffIdsKey", value = "添加员工，存放导购ID列表的Redis key", example = "")
    private String staffIdsKey;

    @ApiModelProperty(name = "groupChatIdKey", value = "所属群聊，存放群聊ID列表的Redis key", example = "select:group_chat:1234567890")
    private String groupChatIdKey;

    @ApiModelProperty(name = "sharePhone", value = "邀请人手机号", example = "")
    private String sharePhone;

    @ApiModelProperty(name = "mktpActivityType", value = "私域营销活动类型 1群 2客户", example = "")
    private Integer mktpActivityType;

    private Integer pageNumber = 1;

    private Integer pageSize = 10;

    private boolean exportFlag;

    private Long exportRecordId;
}
