package com.bizvane.mktcenterservice.models.vo.tree3.respvo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class GetCertificationInfoRespVO {


    private Long sysCompanyId;

    private Long sysBrandId;

    @ApiModelProperty("会员编号")
    private String membersCode;

    @ApiModelProperty("会员姓名")
    private String memberName;

    @ApiModelProperty("会员头像")
    private String memberPhoto;

    @ApiModelProperty("性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("首次参加工作日期")
    private String firstWorkDate;
    @ApiModelProperty("工龄")
    private Long workAge;


    @ApiModelProperty("施工能力集合")
    private List<SelectPageConstructabilityRespVO> constructabilityVOList;

    @ApiModelProperty("三棵树认证证书列表")
    private List<CertVo> treeTreesCertVoList;

    @ApiModelProperty("国家认证证书列表")
    private List<CertVo> countryCertVoList;


    @Data
    public static class CertVo {
        @ApiModelProperty("认证类型（1 三棵树认证 2 国家认证)")
        private String certificationType;
        @ApiModelProperty("认证名称")
        private String certificationName;
        @ApiModelProperty("认证简称")
        private String certificationSimpleName;
        @ApiModelProperty("认证简介")
        private String certificationDesc;
        @ApiModelProperty("证书类型")
        private String certType;
        @ApiModelProperty("证书级别")
        private String certLevel;
        @ApiModelProperty("证书编号")
        private String certNo;
        @ApiModelProperty("证书颁发时间")
        private Date awardTime;
        @ApiModelProperty("证书过期时间")
        private Date expireTime;

    }
}
