package com.bizvane.mktcenterservice.rpc;

import java.util.List;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeResVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreReqVO;
import com.bizvane.mktcenterservice.models.vo.MemberTaskPrizeStoreResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeAddressReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailReqVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeDetailResVO;
import com.bizvane.mktcenterservice.models.vo.TaskPrizeExchangeReqVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskPrizeRpc")
public interface TaskPrizeServiceRpc {

    /**
     * 查询用户从任务中获取的奖品
     * @param po
     * @return
     */
    @RequestMapping("getTaskPrizeRecord")
    ResponseData<List<MemberTaskPrizeResVO>> getTaskPrizeRecord(@RequestBody MemberTaskPrizeReqVO po);

    /**
     * 查询用户从任务中获取的奖品
     * @param reqVO
     * @return
     */
    @RequestMapping("selectStoreIds")
    public ResponseData<MemberTaskPrizeStoreResVO> selectStoreIds(@RequestBody MemberTaskPrizeStoreReqVO reqVO);

    /**
     * 新增实物奖品收货地址/自提门店
     * @param reqVO
     * @return
     */
    @RequestMapping("addPrizeAddressNew")
    ResponseData addPrizeAddressNew(@RequestBody TaskPrizeAddressReqVO reqVO);

    /**
     * 获取奖品兑换详情
     * @param reqVO
     * @return
     */
    @RequestMapping("getPrizeExchangeDetail")
    ResponseData<TaskPrizeExchangeDetailResVO> getPrizeExchangeDetail(@RequestBody TaskPrizeExchangeDetailReqVO reqVO);

    /**
     * 兑换实物奖品
     * @param reqVO
     * @return
     */
    @RequestMapping("receivePrize")
    ResponseData receivePrize(@RequestBody TaskPrizeExchangeReqVO reqVO);
}
