package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.vo.ActivityPointsDistributeVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityPointsDistributeRpc")
public interface ActivityPointsDistributeServiceRpc {

    /**
     * 获取积分派发活动详情
     * @param vo
     * @return
     */

    @RequestMapping(value = "/getActivityPointsDistribute",method = RequestMethod.POST)
    ResponseData<ActivityPointsDistributeVO> getActivityPointsDistribute(@RequestBody ActivityPointsDistributeVO vo);


    /**
     * 小程序执行获取积分派发
     * @param vo
     * @return
     */
    @RequestMapping(value = "/executePointsDistributeActivity",method = RequestMethod.POST)
    ResponseData<ActivityPointsDistributeVO> executePointsDistributeActivity(@RequestBody ActivityPointsDistributeVO vo);
}
