package com.bizvane.mktcenterservice.interfaces.mktp;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.mktcenterservice.models.vo.mktp.*;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * @author yuantq
 * @date 2023/6/21
 */
public interface ChatFissionActivityService {

    /**
     * 新增私域群裂变活动
     * @param addRequestVO
     * @param activityType
     * @param prefix
     * @param wxPath
     * @param sysAccountPO
     * @return
     */
    ResponseData<JSONObject> addChatFissionActivity(FissionActivityRequestVO addRequestVO, Integer activityType, String prefix, String wxPath, SysAccountPO sysAccountPO);

    /**
     * 新增私域客户裂变活动
     * @param addRequestVO
     * @param activityType
     * @param prefix
     * @param wxPath
     * @param sysAccountPO
     * @return
     */
    ResponseData<JSONObject> addCustomerFissionActivity(FissionActivityRequestVO addRequestVO, Integer activityType, String prefix, String wxPath, SysAccountPO sysAccountPO);

    /**
     * 根据私域活动获取活动详情
     * @param mktpActivityId
     * @return
     */
    ResponseData<FissionActivityResponseVO> getMktpActivityDetailById(Long mktpActivityId);

    /**
     * 编辑客户群裂变活动
     * @param updateRequestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<JSONObject> updateChatFissionActivity(FissionActivityRequestVO updateRequestVO, SysAccountPO sysAccountPO);

    /**
     * 编辑客户裂变活动
     * @param updateRequestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<JSONObject> updateCustomerFissionActivity(FissionActivityRequestVO updateRequestVO, SysAccountPO sysAccountPO);

    /**
     * 根据活动主键ID禁用活动
     * @param mktpActivityId
     * @param sysAccountPO
     * @return
     */
    ResponseData<Boolean> stopMktpActivityById(Long mktpActivityId, SysAccountPO sysAccountPO);

    /**
     * 小程序端获取客户群裂变活动详情
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityDetailResponseVO> selectActivityDetail(FissionActivityParamsVO paramsVO);

    /**
     * 小程序端会员客户群裂变活动邀请好友助力
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteResponseVO> inviteNow(FissionActivityParamsVO paramsVO);

    /**
     * 小程序端会员客户裂变活动邀请好友助力
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteResponseVO> customerActivityInviteNow(FissionActivityParamsVO paramsVO) throws BizException;

    /**
     * 获取活动规则
     * @param paramsVO
     * @return
     */
    ResponseData<ActivityRuleResponseVO> getActivityRuleByCode(FissionActivityParamsVO paramsVO);

    /**
     * 获取邀请记录
     * @param paramsVO
     * @return
     */
    ResponseData<FissionActivityInviteRecordVO> getInvitationRecord(FissionActivityParamsVO paramsVO);

    /**
     * 领奖
     * @param paramsVO
     * @return
     */
    ResponseData<ReceiveAwardResponseVO> receiveAward(FissionActivityParamsVO paramsVO);

    /**
     * 获取客服员工活码相关信息
     * @param lifeCodeId
     * @return
     */
    ResponseData<LifeCodeResponseVO> getLiveCodeInfoById(Long lifeCodeId);

    /**
     * 根据中奖记录ID获取可提货门店
     * @param paramsVO
     * @return
     */
    ResponseData<List<Long>> selectStoreIds(FissionActivityParamsVO paramsVO);

    /**
     * 根据活动ID获取数据概览
     * @param requestVO
     * @return
     */
    ResponseData<MktpFissionActivityDataOverviewVO> getOverviewDataByActivityId(MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 分页获取参与记录
     * @param requestVO
     * @return
     */
    ResponseData<PageInfo<ActivityInvolvedRecordVO>> selectShareRecordPage(MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 根据参与记录获取邀请详情
     * @param requestVO
     * @return
     */
    ResponseData<MktpActivityInvitationDetailVO> selectInvitationDetail(MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 分页获取获奖记录
     * @param requestVO
     * @return
     */
    ResponseData<PageInfo<MktpActivityAwardRecordVO>> selectActivityAwardRecordPage(MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 核销
     * @param requestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<Boolean> activityAwardWriteOff(MktpFissionActivityDataStatisticsRequestVO requestVO, SysAccountPO sysAccountPO);

    /**
     * 根据活动ID获取活动信息
     * @param mktpActivityId
     * @return
     */
    ResponseData<MktpActivityVO> selectMktpActivityInfoById(Long mktpActivityId);

    /**
     * 导出参与记录
     * @param requestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<Boolean> awardRecordDataExport(MktpFissionActivityDataStatisticsRequestVO requestVO,SysAccountPO sysAccountPO);

    /**
     * 导出获奖记录
     * @param requestVO
     * @param sysAccountPO
     * @return
     */
    ResponseData<Boolean> shareRecordDataExport(MktpFissionActivityDataStatisticsRequestVO requestVO,SysAccountPO sysAccountPO);

    /**
     * 获取参与记录导出数据
     * @param requestVO
     * @return
     */
    List<ActivityInvolvedRecordVO> selectExportShareRecordData(MktpFissionActivityDataStatisticsRequestVO requestVO);

    /**
     * 获取获奖记录导出数据
     * @param requestVO
     * @return
     */
    List<MktpActivityAwardRecordVO> selectExportAwardRecordData(MktpFissionActivityDataStatisticsRequestVO requestVO);
}
