package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.couponfacade.models.po.CouponDefinitionPOWithBLOBs;
import com.bizvane.mktcenterservice.models.bo.ActivityGiftbagBO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2018/11/23 11:38
 */
@Data
public class CouponRecordVO {
    //pc端
    private Integer pageSize=20;
    private Integer pageNumber=1;
    private String exchangeCode;
    private String convertCouponRecordCode;
    private String memberName;
    private String cardNo;
    private String couponName;
    private String couponCodes;
    private Date startTime;
    private Date endTime;
    private String startTimestr;
    private String endTimestr;
    private Long brandId;
    private Long sysCompanyId;
    private String tmallNick;
    //小程序
    private Boolean canConvertCoupon=Boolean.TRUE;
    //券和商品是否隔离
    private Boolean hiddenGoods=Boolean.FALSE;
    //可用积分
    private Integer countIntegral;
    private String memberCode;
    //门店id
    private Long openCardStoreId;
    private String openCardStoreIdStr;
    //已经兑换足够数量的限制券id集合
    private List<Long> exchangeIds;

    //积分商城活动兑换限制集合
    private List<String> exchangeCodes;

    //兑换券  参数
    //private Integer couponId;
    //private String couponCode;
    private Long exchangeId;
    private Integer exchangeNum;
    //会员的等级
    private Long mbrLevelId;
    private String mbrLevelIdStr;
    //兑换的礼包
    private ActivityGiftbagBO giftBagVO;
    //该记录是礼包还是券
    private Integer integralExchangeType;
    private CouponDefinitionPOWithBLOBs couponDefinitionPO;
    private Long convertCouponRecordId;
    //是否热门商品
    private Boolean hotGoods;
    //订单状态 0.默认创建 1.待付款 2.已付款
    private Integer orderStatus;
    //支付类型
    private Integer exchangePriceType;

    /**
     * 0 计算个人限兑
     * 1 计算总限兑换
     */
    private Integer inventoryReductionType;
    //积分商城活动类型
    private Integer activityType;
    //积分商城活动id
    private Long  activityId;

    @ApiModelProperty(name = "memberStoreName", value = "会员下单所属门店名称")
    private String memberStoreName;

    @ApiModelProperty(name = "memberStoreCode", value = "会员下单所属门店编号")
    private String memberStoreCode;

    @ApiModelProperty(name = "memberStoreId", value = "会员下单所属门店id")
    private Long memberStoreId;

    private Long sysAccountId;
    /**
     * 运营组织code
     */
    private String organizationCode;

}
