package com.bizvane.mktcenterservice.models.po;

import lombok.*;

import java.io.Serializable;
import java.util.Date;


/**
 * 自动营销任务执行主表
 * @author lipeng
 */
@Data
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MktAutoTaskExecuteCountPO implements Serializable {

    @io.swagger.annotations.ApiModelProperty(value = "pkid", name = "autoTaskCountId", required = false, example = "")
    private Long autoTaskCountId;
    @io.swagger.annotations.ApiModelProperty(value = "sysCompanyId", name = "所属企业id", required = false, example = "")
    private Long sysCompanyId;
    @io.swagger.annotations.ApiModelProperty(value = "sysBrandId", name = "所属品牌id", required = false, example = "")
    private Long sysBrandId;
    @io.swagger.annotations.ApiModelProperty(value = "autoTaskDefId", name = "关联自动营销id", required = false, example = "")
    private Long autoTaskDefId;
    @io.swagger.annotations.ApiModelProperty(value = "taskCode", name = "任务编号", required = false, example = "")
    private String taskCode;
    @io.swagger.annotations.ApiModelProperty(value = "taskExecutionNumber", name = "任务执行次数", required = false, example = "")
    private Integer taskExecutionNumber;
    @io.swagger.annotations.ApiModelProperty(value = "aimsMemberNumber", name = "目标会员人数", required = false, example = "")
    private Integer aimsMemberNumber;
    @io.swagger.annotations.ApiModelProperty(value = "arriveNumber", name = "目标会员人数", required = false, example = "")
    private Integer arriveNumber;
    @io.swagger.annotations.ApiModelProperty(value = "messageReachNumber", name = "到达张数", required = false, example = "")
    private Integer messageReachNumber;
    @io.swagger.annotations.ApiModelProperty(value = "valid", name = "数据有效性 1=有效 0=无效", required = false, example = "")
    private Integer valid;
    @io.swagger.annotations.ApiModelProperty(value = "remark", name = "备注", required = false, example = "")
    private String remark;
    @io.swagger.annotations.ApiModelProperty(value = "createUserId", name = "创建人id", required = false, example = "")
    private Integer createUserId;
    @io.swagger.annotations.ApiModelProperty(value = "createUserName", name = "创建人名称", required = false, example = "")
    private String createUserName;
    @io.swagger.annotations.ApiModelProperty(value = "createDate", name = "创建日期", required = false, example = "")
    private Date createDate;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserId", name = "修改人id", required = false, example = "")
    private Long modifiedUserId;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedUserName", name = "修改人名称", required = false, example = "")
    private String modifiedUserName;
    @io.swagger.annotations.ApiModelProperty(value = "modifiedDate", name = "修改日期", required = false, example = "")
    private Date modifiedDate;
    @io.swagger.annotations.ApiModelProperty(value = "version", name = "版本号", required = false, example = "")
    private Integer version;
}