package com.bizvane.mktcenterservice.models.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 活动报名表
 */
@ApiModel(value = "活动报名")
@Data
public class TMktActivitySignup {
    private Long mktActivitySignupId;

    /**
     * 活动企业id
     */
    @ApiModelProperty(value = "活动企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "报名时是否是会员")
    private Boolean member;

    /**
     * 活动品牌id
     */
    @ApiModelProperty(value = "活动品牌id")
    private Long sysBrandId;

    /**
     * 关联活动id
     */
    @ApiModelProperty(value = "关联活动id")
    private String mktActivityCode;

    /**
     * 会员id
     */
    @ApiModelProperty(value = "会员id")
    private String mbrMemberCode;

    /**
     * 报名途径 0自己报名 1别人帮自己报名
     */
    @ApiModelProperty(value = "报名途径 0自己报名 1别人帮自己报名")
    private Byte signUpSource;

    /**
     * 自定义属性
     */
    @ApiModelProperty(value = "自定义属性")
    private String customProperties;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 创建人id
     */
    @ApiModelProperty(value = "创建人id")
    private Long createUserId;

    /**
     * 创建人姓名
     */
    @ApiModelProperty(value = "创建人姓名")
    private String createUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 修改人id
     */
    @ApiModelProperty(value = "修改人id")
    private Long modifiedUserId;

    /**
     * 修改人姓名
     */
    @ApiModelProperty(value = "修改人姓名")
    private String modifiedUserName;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private Date modifiedDate;

    /**
     * 数据有效性：1=有效；0=无效
     */
    @ApiModelProperty(value = "数据有效性：1=有效；0=无效")
    private Boolean valid;

    /**
     * 是否已签到
     */
    @ApiModelProperty(value = "是否已签到")
    private Boolean signin;

    /**
     * 签到时间
     */
    @ApiModelProperty(value = "签到时间")
    private Date signinTime;

    private String signupUserName;
    private String signupUserPhone;
}