package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivityNotifyVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 是否立即发送:1:是，0:否
     */
    private Integer sendNow;

    /**
     * 活动开始前多少天发
     */
    private String beforeStartDay;

    /**
     * 活动结束前多少天发
     */
    private String beforeEndDay;

    /**
     * 消息通知:WECHAT_NOTIFY:微信通知 MESSAGE_NOTIFY:短信通知 ALL:都通知，NONE:都不通知
     */
    private String notifyType;

    /**
     * 自定义发送时间
     */
    private String definedTime;

    /**
     * 微信通知对象
     */
    private MktMemActivityMsgVO wechat;

    /**
     * 短信对象
     */
    private MktMemActivityMsgVO message;
}
