package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 用于给大数据传递参数的实体
 * @author: Liu Xinpeng
 * @create: 2020-08-11 10:58
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MktBigDataBo implements Serializable {
    /**
     * 调用商家编号
     */
    private String businessNum;
    /**
     * APIkey
     */
    private String apiKey;

    /**
     * 子商户号
     */
    private String subMerchantId;


    /**
     * 具体的活动编号
     */
    private String activitiesCode;

    /**
     * 粒度
     * 1 - 按日
     * 2 - 按月
     */
    private String particleSize;

    /**
     * 活动开始时间
     */
    private String startDate;

    /**
     * 活动时间
     */
    private String endDate;

    /**
     * 页数
     */
    private Integer pageNumber;

    /**
     * 每页多少条
     */
    private Integer pageSize;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 活动名称
     */
    private String activityName;


}