package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 会员消费金额分布responseVo
 * @author: Liu Xinpeng
 * @create: 2020-08-10 15:53
 **/

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class MemberSalesDistribution implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 0-50元
     */
    private String lessFifty;

    /**
     * 51-100元
     */
    private String fiftyOneToOneHundred;

    /**
     * 101-200元
     */
    private String oneHundredAndOneToTwoHundred;

    /**
     * 201-500元
     */
    private String twoHundredAndOneToFiveHundred;

    /**
     * 501-1000元
     */
    private String fiveHundredAndOneToOneThousand;

    /**
     * 1001-5000元
     */
    private String oneThousandAndOneTOFiveThousand;

    /**
     * 5001-10000元
     */
    private String fiveThousandAndOneTenThousand;

    /**
     * 10001元以上
     */
    private String moreThanTenThousand;
}