package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.centerstageservice.models.po.SysConfigsPo;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * 积分夺宝service
 */
public interface MktActivityPointsLootService {

    /**
     * 新增/修改积分夺宝活动
     * @param vo
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> addOrUpdate(MktActivityPointsLootVo vo, SysAccountPO sysAccountPO);

    /**
     * 查询积分夺宝活动集合(分页)
     * @param vo
     * @param pageForm
     * @return
     */
    ResponseData<PageInfo<MktActivityPointsLootVo>> selectPage(MktActivityPointsLootVo vo, PageForm pageForm);

    /**
     * 查询积分夺宝活动明细
     * @param mktActivityId
     * @param sysAccountPO
     * @return
     */
    ResponseData<MktActivityPointsLootVo> selectById(Long mktActivityId,SysAccountPO sysAccountPO);

    /**
     * 查询积分夺宝活动明细操作
     * @param operateType
     * @param mktActivityId
     * @param orderNumber
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> operate(Integer operateType, Long mktActivityId, Integer orderNumber,SysAccountPO sysAccountPO);

    /**
     * 积分夺宝活动效果分析
     * @param vo
     * @param pageForm
     * @return
     */
    ResponseData<PageInfo<AnalysisPriceResultVO>> selectStatisticsPage(MktActivityPointsLootRequestVo vo, PageForm pageForm);

    /**
     * 积分夺宝活动会员参与明细
     * @param vo
     * @param pageForm
     * @return
     */
    ResponseData<PageInfo<MktActivityPrizeRecordVO>> selectStatisticsDetailPage(MktActivityPointsLootRequestVo vo, PageForm pageForm);

    /**
     * 导出积分夺宝活动会员参与明细
     * @param vo
     * @return
     */
    ResponseData<String> exportStatisticsDetail(MktActivityPointsLootRequestVo vo,SysAccountPO sysAccountPO);

    /**
     * 会员参与积分夺宝活动抽奖
     * @param vo
     * @return
     */
    ResponseData<String> participationActivity(MktActivityPointsLootRequestVo vo);

    /**
     * 查询积分夺宝活动明细
     * @param vo
     * @return
     */
    ResponseData<MktActivityPointsLootVo> selectActivityDetail(MktActivityPointsLootRequestVo vo);

    /**
     * 查询会员的抽奖记录
     * @param vo
     * @return
     */
    ResponseData<PageInfo<MktMbrPrizeRecordVo>> selectLuckDrawActivityRecord(MktActivityPointsLootRequestVo vo);

    /**
     * 执行积分夺宝活动开奖
     * @param activityCode
     * @return
     */
    ResponseData<String>  executeDrawPrize(String activityCode);

    /**
     * 查询符合会员参与的积分夺宝活动列表
     * @param vo
     * @return
     */
    ResponseData<PageInfo<MktActivityPointsLootVo>> selectFitMbrActivityList(MktActivityPointsLootRequestVo vo);

    /**
     * 增加开奖的job
     * @return
     */
    ResponseData<String>  addDrawPrizeJob();

    /**
     * 审核积分夺宝活动
     * @param po
     * @param sysAccountPO
     * @return
     */
    ResponseData<Integer> checkActivityById(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 补偿退还积分
     * @param activityCode
     * @return
     */
    ResponseData<String> compensateReturnPonits(String activityCode);


    /**
     * 单个活动开奖
     * @param t
     * @return
     */
    Map<String, List<MktActivityPrizeRecordPO>> drawPriceSingleActivity(MktActivityPointsLootVo t);

    /**
     * 补偿积分夺宝活动（解决多次返还积分问题）
     * @param activityCode
     * @param memberCodes
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> executeActivityReturnPoints(String activityCode, String memberCodes, SysAccountPO sysAccountPO);

    /**
     * 结束活动
     * @param vo
     */
    void stopActivity(MktActivityPO vo);

    /**
     * 新增/修改积分夺宝活动规则
     * @param activityRule
     * @param sysAccountPO
     * @return
     */
    ResponseData<String> addOrUpdateRule(String activityRule, SysAccountPO sysAccountPO);


    /**
     * 新增/修改积分夺宝活动规则
     * @param key
     * @param sysAccountPO
     * @return
     */
    ResponseData<SysConfigsPo> selectRule(String key, SysAccountPO sysAccountPO);
}
