package com.bizvane.mktcenterservice.common;

/**
 * @author yuantq
 * @date 2023/4/7
 */
public enum ChannelTypeEnum {

    ONLY_ONE("1","微信会员中心"),

    EVERY_TIME("2","支付宝会员中心");

    /**
     * 投放平台类型
     */
    private String channelType;
    /**
     * 备注
     */
    private String remark;

    ChannelTypeEnum(String channelType, String remark) {
        this.channelType = channelType;
        this.remark = remark;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public static ChannelTypeEnum getEnumByChannelType(String channelType){
        for(ChannelTypeEnum channelTypeEnum : ChannelTypeEnum.values()){
            if(channelType.equals(channelTypeEnum.getChannelType())){
                return channelTypeEnum;
            }
        }
        return null;
    }
}
