package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.CouponIntegralExchangeVO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktConvertCouponRecordVO;
import com.bizvane.mktcenterservice.models.vo.MktGiftBagVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;

/**
 * @Author: lijunwei
 * @Time: 2018/11/23 11:28
 */
public interface ConvertCouponService {

    public ResponseData<PageInfo<MktConvertCouponRecordVO>> getCouponRecordLists(CouponRecordVO vo, SysAccountPO sysAccountPo);

    public ResponseData<CouponIntegralExchangeBO> getConvernCouponLists(CouponRecordVO vo);

    public ResponseData<String> doConvernCoupon(CouponRecordVO vo);

    public ResponseData<PageInfo<MktConvertCouponRecordPO>> getConvernConpouByMember(CouponRecordVO vo);

    public void doExportData(CouponRecordVO vo,HttpServletResponse response) throws IOException;

    public ResponseData doExportData001(CouponRecordVO vo, HttpServletRequest request);

    public ResponseData<CouponIntegralExchangeVO> getCouponAndPrice(CouponRecordVO vo);

    public ResponseData<MktConvertCouponRecordPOWithBLOBs> getConvernConpouDetail(Long convertCouponRecordId);

    public ResponseData validateConvernCoupon(CouponRecordVO vo);

    public ResponseData<MktConvertCouponRecordPO> paySuccess(Long convertCouponRecordId);

    ResponseData<MktGiftBagVO> getGiftBag(Long bizId);

    Boolean getMemberDataDesensitizeByAccountConfig(Long sysAccountId);
}
