package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePOWithBLOBs;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by agan on 2018/11/22.
 */
@Data
public class MktCouponIntegralExchangeVO extends MktCouponIntegralExchangePOWithBLOBs implements Serializable {

    private static final long serialVersionUID = 1L;
    //会员等级集合
    List<MbrLevelModel> mbrLevelModels;

    private String startTime;
    private  String endTime;

    private List<Long> exchangeIds;//id集合
    private Integer restCount;//剩余库存
    //门店实体类
    private List<SysStorePo> sysStorePos;
    //券剩余数量
    private Integer residueCouponNumber;
    private CouponDefinitionPO couponDefinitionPO;
    //券
    private CouponDetailResponseVO couponDetailResponseVO;
    //券类型 券还是券包
    private Integer integralExchangeType;
    //礼包
    private MktGiftBagVO giftBagVO;
    //异业券剩余数量
    private Integer surplusQuantity;
    //
    private  List<String> exchangeCodes;

    @ApiModelProperty(name = "users",notes = "兑换人数")
    private Long users;

    @ApiModelProperty(name = "changeNum",notes = "兑换个数--这个是积分商城记录的券个数")
    private Long changeNum;

    @ApiModelProperty(name = "usedNum",notes = "核销张数")
    private Long usedNum;

    @ApiModelProperty(name = "unUsedNum",notes = "待核销张数")
    private Long unUsedNum;

    @ApiModelProperty(name = "cash",notes = "券收益")
    private BigDecimal cash=BigDecimal.ZERO;

    @ApiModelProperty(name = "userRate",notes = "核销率")
    private BigDecimal userRate=BigDecimal.ZERO;

    @ApiModelProperty(name = "autoUpperShelfJudge",notes = "上架定时器判断")
    private Boolean autoUpperShelfJudge=Boolean.FALSE;

    @ApiModelProperty(name = "autoLowerShelfJudge",notes = "下架定时器判断")
    private Boolean autoLowerShelfJudge=Boolean.FALSE;
}
