package com.bizvane.mktcenterservice.common;

/**
 * @Author: lijunwei
 * @Time: 2019/6/6 11:03
 */
public enum ConvertCouponAndIntegralTypeEnum {
    ACTIVITY_TYPE_ALL(0,"0","0","全部"),
    ACTIVITY_TYPE_REGISGER(1,"10","9","开卡活动"),
    ACTIVITY_TYPE_UPGRADE(2,"35","11","升级活动"),
    ACTIVITY_TYPE_QRCODE(3,"55","12","扫码领券活动"),
    ACTIVITY_TYPE_MANUAL(4,"55","13","手动领券活动"),
    ACTIVITY_TYPE_ORDER(5,"45","14","消费活动"),
    ACTIVITY_TYPE_SIGNIN(6,"50","15","签到活动"),
    ACTIVITY_TYPE_BIRTHDAY(7,"15","16","生日活动"),
    ACTIVITY_TYPE_SMART(8,"无","10","智能营销活动"),
    ACTIVITY_TYPE_EVALUATION(9,"100","23","评价奖励活动"),
    ACTIVITY_TYPE_ANNIVERSARY(10,"90","22","纪念日活动"),
    ACTIVITY_TYPE_PRIZE(11,"103","27","大转盘"),
    ACTIVITY_TYPE_RED_PACKET(12,"104","28","红包膨胀"),
    ACTIVITY_TYPE_EGG(13,"105","29","砸金蛋"),
    ACTIVITY_TYPE_BABY_BIRTHDAY(14,"106","33","宝宝生日活动"),
    ACTIVITY_TYPE_FIRST_SINGLE(15,"107","32","会员首单活动"),
    ACTIVITY_TYPE_SHARK(16,"108","37","摇一摇"),
    ACTIVITY_TYPE_PAY(17,"109","38","储值送礼"),
    ACTIVITY_TYPE_REGISTRATION(18,"88","39","会员报名活动");

    private int activityType;
    private String couponType;
    private String integralType;
    private String message;


    ConvertCouponAndIntegralTypeEnum(int activityType, String couponType, String integralType, String message) {
        this.activityType = activityType;
        this.couponType = couponType;
        this.integralType = integralType;
        this.message = message;
    }

    public static ConvertCouponAndIntegralTypeEnum getConvertCouponAndIntegralTypeEnumByCode(int code){
        for(ConvertCouponAndIntegralTypeEnum convertCouponAndIntegralTypeEnum : ConvertCouponAndIntegralTypeEnum.values()){
            if(code==convertCouponAndIntegralTypeEnum.getActivityType()){
                return convertCouponAndIntegralTypeEnum;
            }
        }
        return null;
    }

    public int getActivityType() {
        return activityType;
    }

    public void setActivityType(int activityType) {
        this.activityType = activityType;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIntegralType() {
        return integralType;
    }

    public void setIntegralType(String integralType) {
        this.integralType = integralType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
