package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivitySendRewardVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 会员编号
     */
    private String memberCode;

    /**
     * 确定唯一值
     */
    private String requestId;

    /**
     * 活动主键id
     */
    private Long id;
    /**
     * 活动编号
     */
    private String taskCode;

    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 倍数积分的倍数
     */
    private BigDecimal multiple;

    /**
     * 奖励的整数积分值
     */
    private Integer score;

    /**
     * 积分类型:simple:整数 multiple:倍数
     */
    private String scoreType;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 券
     */
    private List<MktMemActivityCouponVO> coupon;

    /**
     * 礼包
     */
    private MktMemActivityGiftBagVO giftBag;
}
