package com.bizvane.mktcenterservice.models.newmkt;

import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktMessagePO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.models.auth.In;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @description: 发送短信、微信消息的请求体
 * @author: Liu Xinpeng
 * @create: 2020-08-14 16:19
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivitySendMessage implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;


    /**
     * 业务id
     */
    private Long bizId;
    /**
     * 活动编号
     */
    private String  taskCode;


    /**
     * 创建人
     */
    private String createUserName;
    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 活动类型
     */
    private Integer taskType;


    /**
     * 开始通知时间
     */
    private Date beforeStartTime;

    /**
     * 结束前通知时间
     */
    private Date beforeEndTime;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 是否立即发送 1：是  0.否
     */
    private Integer sendNow;

    /**
     * 自定义发送时间
     */
    private Date customTime;

    /**
     * 通知类型
     * ALL 都通知
     * WECHAT_NOTIFY:微信通知
     * MESSAGE_NOTIFY:短信通知 
     * NONE:都不通知  
     */
    private String notifyType;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO userGroup;

    /**
     * 会员信息
     *  接受String类型的需要转换为对对象类型
     */
    private String userGroupIds;

    /**
     * 消息对象
     */
    private List<MktMessagePO> messageVoList;

    /**
     * 微信消息对象
     */
    private WechatPo wechat;

    /**
     * 消息对象
     */
    private MessagePo message;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date createDate;

}