package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动日业绩分析
 * @author: Liu Xinpeng
 * @create: 2020-08-25 17:45
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivityDaySalesExportVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 分析的日期维度
     */
    private String analysisDate;

    /**
     * GVM
     */
    private String activiesGmv;
    /**
     * 参与会员数
     */
    private String vipNum;
    /**
     * 会员首单数
     */
    private String vipFirstOrderNum;
    /**
     * 客单价
     */
    private String guestPrice;
    /**
     * 连带率
     */
    private String jointRate;
}