package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityRegistrationBO;
import com.bizvane.mktcenterservice.models.bo.TMktActivitySignup;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author liufq
 */
@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityRegistration")
public interface ActivityRegistrationServiceRpc {
    /**
     * 查询活动详情
     */
    @RequestMapping("/detail")
    ResponseData<ActivityRegistrationBO> getActivityRegistrationDetail(String activityCode);

    @RequestMapping("/signup")
    ResponseData<Object> signup(TMktActivitySignup activitySignup);

    @RequestMapping("/getByActivityCodeAndPhone")
    ResponseData<List<TMktActivitySignup>> getByActivityCodeAndPhone(String activityCode, String phone);

    @RequestMapping("/signupHistory")
    ResponseData<List<SignupHistory>> signupHistory(String memberCode);

    @RequestMapping("/signin")
    ResponseData<Object> signin(String activityCode, String phone);
}
