package com.bizvane.mktcenterservice.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * create by yangyonghua on 2022/7/4
 */
@Data
public class SeckillActivityGoodsDTO {
    private Long id;

    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    @NotNull(message = "商品id不能为空")
    private Integer goodsId;

    /**
     * 商品编号
     */
    @ApiModelProperty(value = "商品编号")
    @NotBlank(message = "商品编号不能为空")
    private String goodsNo;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    @NotBlank(message = "商品名称不能为空")
    private String goodsName;

    @ApiModelProperty(name = "price", value = "商品原始积分价格")
    private Long price;

    @ApiModelProperty(name = "cash_price", value = "商品原始现金价格")
    private BigDecimal cashPrice;

    @ApiModelProperty(name = "second_price", value = "商品原始积分+现金-积分价格")
    @Column(name = "second_price")
    private  Long secondPrice;

    @ApiModelProperty(name = "second_cash_price",value = "商品原始积分+现金-现金价格")
    @Column(name = "second_cash_price")
    private  BigDecimal secondCashPrice;

    @ApiModelProperty(value = "秒杀积分价格")
    private Long activityPrice;

    @ApiModelProperty(name = "cash_price", value = "秒杀现金价格")
    private BigDecimal activityCashPrice;

    @ApiModelProperty(name = "activity_second_price",value = "秒杀---积分+现金-积分价格")
    private Long activitySecondPrice;

    @ApiModelProperty(name = "activity_second_cash_price", value = "秒杀---积分+现金-现金价格")
    private BigDecimal activitySecondCashPrice;

    /**
     * 秒杀商品排序
     */
    @ApiModelProperty(value = "秒杀商品排序")
    private Integer activityGoodsSort;

    /**
     * 价格类型 0积分价 1现金价 2积分+现金 （商品明细第一个）
     */
    @ApiModelProperty(value = "价格类型 0积分价 1现金价 2积分+现金 （商品明细第一个）")
    @NotBlank(message = "价格类型不能为空")
    private String priceType;

    @ApiModelProperty(value = "秒杀总库存")
    private Integer activityStock;

    /**
     * 静态秒杀库存
     */
    @ApiModelProperty(value = "静态秒杀总库存")
    private Integer staticActivityStock;

    @ApiModelProperty(value = "秒杀已售库存")
    private Integer activitySalesStock;


    private Integer totalStock;

    private Integer deleted;

    private Integer version;

    /**
     * 已售数量，当活动结束时有值
     */
    @ApiModelProperty(value = "已售数量，当活动结束时有值,商品下所属sku的已售总和")
    private Integer soldNumber;

    @ApiModelProperty(name = "coverImg",value = "列表缩略图地址")
    private String coverImg;
}
