package com.bizvane.mktcenterservice.rpc;

import com.bizvane.centercontrolservice.models.bo.AppletFunctionBO;
import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXBO;
import com.bizvane.mktcenterservice.models.bo.TaskWXDetailBO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by Geng on 2018/8/9.
 */

@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/taskForWXRpc")
public interface TaskServiceForWXRpc {


    @RequestMapping("/getCompleteTask")
    @io.swagger.annotations.ApiModelProperty(value = "brandId,memberCode", name = "该会员已完成和未完成的任务列表", required = false, example = "")
    public ResponseData<PageInfo<TaskWXBO>> getCompleteTask(@RequestBody TaskForWXVO vo);

    @RequestMapping("/getTaskWXDetail")
    @io.swagger.annotations.ApiModelProperty(value = "taskId", name = "任务code", required = false, example = "")
    public ResponseData<TaskWXDetailBO> getTaskWXDetail(@RequestParam Long taskId);

    /**
     * 消费任务详情
     * @param taskId
     * @param memberCode
     * @return
     */
    @RequestMapping("/getTaskOrderDetail")
    @io.swagger.annotations.ApiModelProperty(value = "taskId", name = "任务code", required = false, example = "")
    public ResponseData<TaskWXDetailBO> getTaskOrderDetail(@RequestParam Long taskId, @RequestParam String memberCode);

    @RequestMapping("/getURLDetail")
    @io.swagger.annotations.ApiModelProperty(value = "TaskForWXVO", name = "获取url链接详情", required = false, example = "")
    public ResponseData<AppletFunctionBO> getURLDetail(@RequestBody TaskForWXVO vo);

    //积分兑换券
    //查询对换列表
    @RequestMapping("/getConvernCouponLists")
    public ResponseData<CouponIntegralExchangeBO> getConvernCouponLists(@RequestBody CouponRecordVO vo);

    //积分兑换券
    //查询对换列表
    @RequestMapping("/getConvernCouponListsForActivity")
    public ResponseData<CouponIntegralExchangeBO> getConvernCouponListsForActivity(@RequestBody CouponRecordVO vo);

    //券详情和单价
    @RequestMapping("/getCouponAndPrice")
    public ResponseData<CouponIntegralExchangeVO> getCouponAndPrice(@RequestBody CouponRecordVO vo);

    //券详情和单价
    @RequestMapping("/getCouponAndPriceForActivity")
    public ResponseData<CouponIntegralExchangeVO> getCouponAndPriceForActivity(@RequestBody CouponRecordVO vo);

    //兑换
    @RequestMapping("/doConvernCoupon")
    public ResponseData<String> doConvernCoupon(@RequestBody CouponRecordVO vo);

    //积分清算处理兑换券订单数据
    @RequestMapping("/computeIntegralCost")
    public void computeIntegralCost(@RequestBody IntegralCouponCostComputeVo bo);

    //查询已兑换
    @RequestMapping("/getConvernConpouByMember")
    public ResponseData<PageInfo<MktConvertCouponRecordPO>> getConvernConpouByMember(@RequestBody CouponRecordVO vo);

    //兑换券记录详情
    @RequestMapping("/getConvernConpouDetail")
    public ResponseData<MktConvertCouponRecordPO> getConvernConpouDetail(@RequestParam("convertCouponRecordId") Long convertCouponRecordId);

    //兑换校验
    @RequestMapping("/validateConvernCoupon")
    public ResponseData validateConvernCoupon(@RequestBody CouponRecordVO vo);

    //支付成功
    @RequestMapping("paySuccess")
    public ResponseData<MktConvertCouponRecordPO> paySuccess(@RequestParam("convertCouponRecordId") Long convertCouponRecordId);

    @RequestMapping("/getGiftBag")
    public ResponseData<MktGiftBagVO> getGiftBag(@RequestParam("bizId") Long bizId);


    @RequestMapping("/getCompleteTaskVg")
    @io.swagger.annotations.ApiModelProperty(value = "sysCompanyId,rewarded,groupmemberCode", name = "该会员已完成和未完成的任务列表", required = false, example = "")
    ResponseData<PageInfo<TaskWXBO>> getCompleteTaskVg(@RequestBody TaskForWXVO vo);

    /**
     * 扣减库存
     *
     * @param exchangeId
     * @param stock
     * @return
     */
    @RequestMapping("/changeStock")
    ResponseData<Boolean> changeStock(@RequestBody IntegralActivityVO vo);

    @RequestMapping("/updateExchangeSalesStatus")
    ResponseData<Boolean> updateExchangeSalesStatus(@RequestBody IntegralActivityVO vo);


    /**
     * 通过 兑换券ID 查询列表信息---》营销活动专用
     *
     * @param exchangeIds
     * @return
     */
    @RequestMapping("/getExchangeCouponsByIds")
    ResponseData<List<MktCouponIntegralExchangeVO>> getExchangeCouponsByIds(@RequestBody IntegralActivityVO vo);

    /**
     * 校验活动限购
     * @param vo 入参
     * @return 结果
     */
    @RequestMapping("/checkActivityPurchase")
    ResponseData<Boolean> checkActivityPurchase(@RequestBody CouponRecordVO vo);

    /**
     * 通过 兑换券ID 查询带有优惠券的列表信息 --》营销活动使用
     * @param vo
     * @return
     */
    @RequestMapping("/getExchangeCouponsByIdsForActivity")
    ResponseData<List<MktCouponIntegralExchangeVO>> getExchangeCouponsByIdsForActivity(@RequestBody IntegralActivityVO vo);

    /**
     * 秒杀活动兑换券
     * @param vo
     * @return
     */
    @RequestMapping("/doSeckillConvernCoupon")
    ResponseData<String> doSeckillConvernCoupon(@RequestBody SeckillCouponRecordVO vo);

}
