package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.mktcenterservice.models.po.MktCouponIntegralExchangePOWithBLOBs;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * Created by agan on 2018/11/22.
 */
@Data
public class MktCouponIntegralExchangeVO extends MktCouponIntegralExchangePOWithBLOBs {
    //会员等级集合
    List<MbrLevelModel> mbrLevelModels;

    private String startTime;
    private  String endTime;

    private List<Long> exchangeIds;//id集合
    private Integer restCount;//剩余库存
    //门店实体类
    private List<SysStorePo> sysStorePos;
    //券剩余数量
    private Integer residueCouponNumber;
    private CouponDefinitionPO couponDefinitionPO;
    //券
    private CouponDetailResponseVO couponDetailResponseVO;
    //券类型 券还是券包
    private Integer integralExchangeType;
    //礼包
    private MktGiftBagVO giftBagVO;
    //作为积分商品时的所属俱乐部名称，一个券只能选一个俱乐部
    private String clubName;

    private String clubId;

    private VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo;

    @ApiModelProperty("消耗总积分")
    private Integer  allIntegralNumber;

    @ApiModelProperty("兑换总人数")
    private  Integer totalExchangeNumber;

    @ApiModelProperty("已售数量")
    private  Integer totalSaleQuantity;

    @ApiModelProperty("上架状态中文")
    private  String upStatusStr;

    // 积分兑换券类型0:券1:券包
    @ApiModelProperty("商品类型")
    private  String goodsTypeStr;

    /**
     * 普通活动已兑换数量
     */
    private Integer normalQuantityRedeemed;

    /**
     * 专题已兑换数量
     */
    private Integer thematicQuantityRedeemed;

    /**
     * 秒杀已兑换数量
     */
    private Integer flashSaleQuantityRedeemed;

    /**
     * 是否开启虚拟兑换功能
     */
    private Boolean isVirtualExchange;

    /**
     * 秒杀活动虚拟兑换数
     */

    private Integer flashSaleExchangeCount;

    /**
     * 专题活动虚拟兑换数
     */

    private Integer thematicExchangeCount;


    /**
     * 常规活动虚拟兑换数
     */

    private Integer normalExchangeCount;


    /**
     * 开始计算虚拟兑换数的时间
     */
    private Date virtualExchangeCountStartTime;


}
