package com.bizvane.mktcenterservice.models.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zcc
 * @date 2021/11/23 14:49
 **/
@Data
public class MktContentVo implements Serializable {

    private static final long serialVersionUID = 5750831215353151371L;

    /**
     * t_mkt_generalize主键id
     */
    private Long mktContentId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 渠道内容code
     */
    private String contentCode;

    /**
     * 渠道内容名称
     */
    private String contentName;

    /**
     * 内容类型：1.微信会员中心小程序 2.微信公众号 3.外部系统功能'
     */
    private Integer contentType;

    /**
     * 投放渠道名称过个","分割
     */
    private String channelAllName;

    /**
     * 来源数量
     */
    private Integer sourceCount;

    /**
     * 内容投放状态：1.生成中 2.投放中 3.已终止
     */
    private Integer status;

    /**
     * 是否长期有效 true：是 false：否
     */
    private Boolean longTerm;

    /**
     * 有效开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date startTime;

    /**
     * 有效结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date endTime;

    /**
     * 创建者姓名
     */
    private String createUserName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date createDate;


}
