package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.mktcenterservice.models.bo.*;
import com.bizvane.mktcenterservice.models.po.MktTaskModifyRecordPo;
import com.bizvane.mktcenterservice.models.po.MktTaskModifyRecordPoWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktTaskOrderPO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.mktcenterservice.models.vo.TaskCallBackVO;
import com.bizvane.mktcenterservice.models.vo.TaskUpdateRecordVO;
import com.bizvane.mktcenterservice.models.vo.TaskVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import java.text.ParseException;
import java.util.List;

/**
 * @author chen.li
 * @date on 2018/7/16 14:06
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public interface TaskOrderService {

    /**
     * 查询任务详情
     */
    List<TaskDetailBO> getOrderTaskDetails(Long mktTaskId);
    /**
     * 查询任务列表
     * @return
     */
    List<TaskVO> selectTask(TaskVO vo);

    /**
     * 新增任务
     * @return
     */
    ResponseData<Integer> addTask(TaskBO bo, SysAccountPO stageUser) throws ParseException;

    /**
     * 计算任务的奖励信息
     * @param orderModel
     */
    void calcOrderTaskReward(OrderModel orderModel);

    /**
     * 计算任务的奖励信息 -退单 扣积分
     * @param orderModel
     */
    void calcCancelOrderTaskReward(OrderModel orderModel);

    /**
     * 修改消费任务
     * @return
     */
    ResponseData updateOrderTask(TaskBO bo, SysAccountPO stageUser);

    /**
     * 修改消费任务
     * @return
     */
    ResponseData updateOrderTaskInfo(TaskBO bo, SysAccountPO stageUser);

    /**
     * 查询详情信息
     * @param taskVO
     * @param stageUser
     * @return
     */
    TaskBO queryTaskOrderDetail(TaskVO taskVO, SysAccountPO stageUser);

    /**
     * 查询修改记录
     * @anthor shifeng
     * @param  taskVO
     * @return
     * 2023-1-31 12:37:18
     */
    ResponseData<PageInfo<MktTaskModifyRecordPoWithBLOBs>> queryUpdateRecord(TaskVO taskVO, PageForm pageForm);

    /**
     * 查询修改详情
     * @anthor shifeng
     * @param
     * @return
     * 2023-1-31 12:37:18
     */
    TaskUpdateRecordVO queryUpdateDetail(MktTaskModifyRecordPo mktTaskModifyRecordPo);

    Integer modifieOrderTask(MktTaskOrderPO po, SysAccountPO stageUser);

    ResponseData doTaskQuestionnaire(TaskAwardBO vo);

    ResponseData<TaskQuestionnaireRewardBO> getTaskRewardDetail(Long mktTaskId);

    ResponseData<Boolean> getTaskByTemplateCode(String templateCode);

    ResponseData<TaskQuestionnairePrepareDoBO> prepareDoTaskQuestionnaire(TaskAwardBO vo);

    /**
     * 锦泓第三方调查问卷回调接口
     * @param taskCallBackVO
     * @return  ResponseData
     * 2022-11-6 15:51:59
     */
    ResponseData doJhTaskQuestionnaireCallBack(TaskCallBackVO taskCallBackVO);

}
