package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道来源动作类型
 */
@Getter
/**
 * 订单支付枚举
 */
public enum ContentChannelSourceActionTypeEnum {
    /**
     *动作/事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
     */
    PV(1, "浏览"),
    REGISTER(2, "注册"),
    BIND(3, "绑定"),
    JOIN_CLUB(4, "点亮俱乐部"),
    PARTAKEN(5, "参与"),
    GET_COUPON(6, "领券"),
    EXCHANGE(7, "兑换")
    ;

    private Integer code;
    private String message;

    ContentChannelSourceActionTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ContentChannelSourceActionTypeEnum getEnumByCode(int code){
        for (ContentChannelSourceActionTypeEnum value : values()) {
            if (value.getCode() == code){
                return value;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
