package com.bizvane.mktcenterservice.rpc.vo;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * create by yangyonghua on 2022/7/4
 */
public enum SeckillActivityType {
    DAY(0, "每天"),
    WEEK(1, "每周"),
    MONTH(2, "每月"),
    CUSTOMIZE(3, "自定义");

    private Integer code;


    private String message;

    SeckillActivityType(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
    public static SeckillActivityType getByCode(Integer code) {
        SeckillActivityType[] values = SeckillActivityType.values();
        for (SeckillActivityType value : values) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }
    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static String getFormatRule(int code, String unformattedRule) {
        if (code >= 4 || StringUtils.isBlank(unformattedRule)) {
            return null;
        }
        String[] rules = unformattedRule.split(",");
        if (ArrayUtils.isEmpty(rules)) {
            return null;
        }
        String result = null;
        switch (code) {
            case 0:
                result = "每天";
                break;
            case 1:
                List<String> dayOfWeek = Arrays.stream(rules).map(Integer::valueOf).map(SeckillActivityType::getWeekDay).collect(Collectors.toList());
                result = String.join(",", dayOfWeek);
                break;
            case 2:
                List<String> daysOfMonth = Arrays.stream(rules).map(rule -> {
                    return rule + "号";
                }).collect(Collectors.toList());
                result = String.join(",", daysOfMonth);
                break;
            case 3:
                result = unformattedRule;
                break;
            default:
                result = null;
        }
        return result;

    }

    private static String getWeekDay(int num) {
        String decribe = null;
        switch (num) {
            case 1:
                decribe = "周一";
                break;
            case 2:
                decribe = "周二";
                break;
            case 3:
                decribe = "周三";
                break;
            case 4:
                decribe = "周四";
                break;
            case 5:
                decribe = "周五";
                break;
            case 6:
                decribe = "周六";
                break;
            case 7:
                decribe = "周日";
                break;
            default:
                throw new RuntimeException("");
        }
        return decribe;
    }

}
