package com.bizvane.mktcenterservice.rpc.vo;

import com.bizvane.mktcenterservice.common.DateUtil;
import org.joda.time.DateTime;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * create by yangyonghua on 2022/7/4
 */
public enum SeckillActivityStatus {

    HAVE_NOT_START(0, "未开始"),
    ON_GOING(1, "进行中"),
    HAS_ENDED(2, "已结束"),
    HAS_BEEN_STOP(3, "已停用");

    private Integer code;

    private String message;

    SeckillActivityStatus(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static String getMessageFromCode(Integer code) {
        SeckillActivityStatus[] values = SeckillActivityStatus.values();
        for (SeckillActivityStatus value : values) {
            if (value.code == code) {
                return value.getMessage();
            }
        }
        return null;
    }

    public static SeckillActivityStatus correctStatus(Integer type, String rule, Long seckillBeginTime, Long seckillEndTime, Integer disabled) throws Exception {
        if (disabled == 1) {
            return SeckillActivityStatus.HAS_BEEN_STOP;
        }
        SeckillActivityStatus currentStatus = null;
        if (type == null || seckillBeginTime == null || seckillEndTime == null) {
            throw new Exception("传入参数有误");
        }
        DateTime dateTime = new DateTime();
        Date currentTime = dateTime.toDate();
        long timeOffset = dateTime.getSecondOfDay();
        boolean inCurrentTime = timeOffset >= seckillBeginTime && timeOffset <= seckillEndTime;
        SeckillActivityType currentType = SeckillActivityType.getByCode(type);
        switch (currentType) {
            case DAY:
                currentStatus = inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            case WEEK:
                String[] week = rule.split(",");
                String dayOfWeek = dateTime.getDayOfWeek() + "";
                List<String> weekList = Arrays.asList(week);
                currentStatus = weekList.contains(dayOfWeek) && inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            case MONTH:
                String[] month = rule.split(",");
                String dayOfMonth = dateTime.getDayOfMonth() + "";
                List<String> monthList = Arrays.asList(month);
                currentStatus = monthList.contains(dayOfMonth) && inCurrentTime ? SeckillActivityStatus.ON_GOING : SeckillActivityStatus.HAVE_NOT_START;
                break;
            case CUSTOMIZE:
                String[] date = rule.split("~");
                Date begin = DateUtil.parse(date[0], DateUtil.ymd);
                Date end = DateUtil.parse(date[1] + " " + DateUtil.parseTime(seckillEndTime), DateUtil.ymdhms);
                if (currentTime.compareTo(end) > 0) {
                    currentStatus = SeckillActivityStatus.HAS_ENDED;
                    break;
                }
                if (currentTime.compareTo(begin) >= 0 && timeOffset >= seckillBeginTime && seckillEndTime >= timeOffset) {
                    currentStatus = SeckillActivityStatus.ON_GOING;
                } else {
                    currentStatus = SeckillActivityStatus.HAVE_NOT_START;
                }
                break;
            default:
        }
        if (currentStatus == null) {
            throw new Exception("传入参数有误");
        }
        return currentStatus;
    }

    public static boolean checkStatus(SeckillActivityStatus activityStatus) {
        if (HAS_ENDED.getCode().equals(activityStatus.getCode()) || HAS_BEEN_STOP.getCode().equals(activityStatus.getCode())) {
            return true;
        }
        return false;
    }

}
