package com.bizvane.mktcenterservice.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 秒杀活动券
 */
@Data
public class SeckillActivityCouponDTO {
    private Long id;
    /**
     * 兑换券id
     */
    @ApiModelProperty(value = "兑换券id")
    private Long exchangeId;

    private String exchangeCode;


    /**
     * 券名称
     */
    @ApiModelProperty(value = "券名称")
    private String couponName;

    @ApiModelProperty(value = "兑换券积分")
    private Integer exchangePrice;

    @ApiModelProperty(value = "兑换券现金")
    private BigDecimal exchangeCashPrice;

    @ApiModelProperty(value = "兑换券价格类型")
    private String exchangePriceType;

    @ApiModelProperty(value = "库存数量")
    private Integer stockCount;


    private Integer orderPieceNum = 0;

    /**
     * 活动积分价格
     */
    @ApiModelProperty(value = "活动积分价格")
    private Long activityPrice;
    /**
     * 活动现金价
     */
    @ApiModelProperty(value = "活动现金价")
    @Digits(integer = 10, fraction = 2, message = "活动现金价整数位最大为10，小数位最大为2")
    private BigDecimal activityCashPrice;
    /**
     * 价格类型 0积分价 1现金价 2积分+现金 （商品明细第一个）
     */
    @ApiModelProperty(value = "价格类型 0积分价 1现金价 2积分+现金 （商品明细第一个）")
    @NotBlank(message = "价格类型不能为空")
    private String priceType;
    /**
     * 活动库存
     */
    @ApiModelProperty(value = "活动库存")
    @NotNull(message = "活动库存不能为空")
    @Min(value = 0, message = "活动库存仅支持整数，必须小于等于实际库存")
    private Integer activityStock;



    /**
     * 静态活动库存
     */
    @ApiModelProperty(value = "静态活动库存")
    @NotNull(message = "静态活动库存不能为空")
    @Min(value = 0, message = "静态活动库存仅支持整数，必须小于等于实际库存")
    private Integer staticActivityStock;

    @ApiModelProperty(value = "活动销售库存")
    private Integer activitySalesStock;

    /**
     * 变化的库存，不对外暴漏,正数表示直接从常规库存添加到活动库存中，负数则相反
     */
    private Integer changeStock;
    /**
     * 商品排序
     */
    @ApiModelProperty(value = "商品排序")
    @NotNull(message = "商品排序不能为空")
    private Integer activityGoodsSort;

    /**
     * 前端校验用，编辑的时候，不能大于这个值
     */
    private Integer maxStock;

    private Integer deleted;


    /**
     * 以下数据为设置端左侧编辑新增券预览设置 （变量命名保持和新增时兑换券服务返回格式一样）
     * 由于券预览只需要部分信息，因此以下只返回部分数据
     */



    /**
     * 兑换券主图 (当前实体冗余一份，便于前端解析)
     */
    private String mainImgUrl;

    /**
     * 兑换券类型 0单张优惠券 1券包
     */
    private Integer integralExchangeType;

    /**
     * 已售数量
     */
    private Integer soldNumber;
}
