package com.bizvane.mktcenterservice.rpc;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.bo.ActivityOrderBO;
import com.bizvane.mktcenterservice.models.po.MktActivityFirstOrderPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityRecordPO;
import com.bizvane.mktcenterservice.models.vg.VGActivityEvaluationRewardVo;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by agan on 2018/7/27.
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/activityRpc")
public interface ActivityServiceRpc {
 /**
  * 审核
  *
  * @param
  * @return
  */
 @RequestMapping("checkActivityById")
 ResponseData<Integer> checkActivityByIdRpc(@RequestBody SysCheckPo po);
 
 /**
   *会员首单
  *必填字段sysCompanyId，sysBrandId，memberCode，orderDate
  * @param
  * @return
  */
 @RequestMapping("saveFristOrder")
 public ResponseData<String> saveFristOrder(@RequestBody MktActivityFirstOrderPO po);

 /**
  * 禁用/启用活动
  *
  * @param vo
  * @return
  */
 @RequestMapping("updateActivityById")
 public ResponseData<Integer> updateActivityById(@RequestBody ActivityVO vo);

 /**
  * 查询开卡活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityRegisterById")
 public ResponseData<ActivityBO> selectActivityRegisterById(@RequestParam("activityCode") String activityCode);

 /**
  * 查询活动详情
  * @param activityId
  * @return
  */
 @RequestMapping("selectActivityById")
 public ResponseData<MktActivityPO> selectActivityById(@RequestParam("activityId") Long activityId);

 /**
  * 查询活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityOrderById")
 public ResponseData<ActivityBO> selectActivityOrderById(@RequestParam("activityCode") String activityCode);

 /**
  * 查询活动详情
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityUpgradesById")
 ResponseData<ActivityBO> selectActivityUpgradesById(@RequestParam("activityCode") String activityCode);

 /**
  *宝宝生日
  */
 @RequestMapping("selectActivityBabyBirthdayById")
 public ResponseData<ActivityBO> selectActivityBabyBirthdayById(@RequestParam("activityCode") String activityCode);

 /**
  *首单
  */
 @RequestMapping("selectActivityFirstOrderById")
 public ResponseData<ActivityBO> selectActivityFirstOrderById(@RequestParam("activityCode") String activityCode);
 /**
  * 小程序端活动列表
  *
  * @param vo
  * @return
  */
 @RequestMapping("getActivityList")
 ResponseData<List<ActivityVO>> getActivityList(@RequestBody ActivityVO vo);

 /**
  * 签到列表
  * @param vo
  * @return
  */
 @RequestMapping("getActivityRecordPOList")
 public ResponseData<List<ActivitySignRecordResponseVo>> getActivitySignRecordList(@RequestBody MktActivityRecordVO vo);
 /**
  * 查询会员该签到活动是否可参与
  * @param
  * @return
  */
 @RequestMapping("getIsSignAble")
 public ResponseData<Boolean> getIsSignAble(@RequestBody MemberInfoModel vo);

 @PostMapping("queryExecuteSignActivity")
 public ResponseData<ActivitySignQueryResponseVo> queryExecuteSignActivity(@RequestBody ActivitySignQueryRequestVo requestVo);
 /**
  * 执行活动
  * @param
  * @return
  */
 @RequestMapping("executeActivitySignin")
 public ResponseData<Integer> executeActivitySignin(@RequestBody MemberInfoModel vo);

 /**
  * 执行评价奖励活动
  * @param vo
  * @return
  */
 @RequestMapping("executeEvaluationActivity")
 public ResponseData<Integer> executeActivityEvaluation(@RequestBody MemberInfoModel vo);


 /**
  * 执行评价奖励活动
  * @param vo
  * @return
  */
 @RequestMapping("executeEvaluationActivityNew")
 public ResponseData<Integer> executeActivityEvaluationNew(@RequestBody VGActivityEvaluationRewardVo vo);

 /**
  * 执行开卡活动
  * @param vo
  * @return
  */
 @RequestMapping("executeActivity")
 ResponseData<Integer> executeActivity(@RequestBody MemberInfoModelVOActivity vo);

 /**
  * 升级活动
  * @param vo
  * @return
  */
 @RequestMapping("executeUpgrades")
 ResponseData<Integer> executeUpgrades(@RequestBody MemberInfoModel vo);

 @RequestMapping("judgeMember")
 public  ResponseData<Integer> judgeMember(@RequestBody JudgeMemberVO vo);

 @RequestMapping("getMinActivityEvaluationWordNum")
 public ResponseData<Integer> getMinActivityEvaluationWordNum(@RequestBody MemberInfoModel vo);
 
 /**
  * 查询活动详情，小程序端使用
  *
  * @param activityCode
  * @return
  */
 @RequestMapping("selectActivityOrderById2C")
 ResponseData<ActivityOrderBO> selectActivityOrderById2C(@RequestParam("activityCode") String activityCode);



 /**
  * vg 小程序端活动列表
  *
  * @param vo
  * @return
  */
 @RequestMapping("getActivityListVg")
 ResponseData<List<ActivityVO>> getActivityListVg(@RequestBody ActivityVO vo);


 @RequestMapping("checkNowActivityIsHaveMember")
  ResponseData<CheckActivityVo> checkNowActivityIsHaveMember(@RequestParam("mktActivityId") Long mktActivityId, @RequestParam("memberCode") String memberCode);

 @RequestMapping("checkNowBrandIsHaveMember")
 ResponseData<CheckActivityVo> checkNowBrandIsHaveMember(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("memberCode") String memberCode);


 }
