package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.mktcenterservice.models.bo.ActivityBO;
import com.bizvane.mktcenterservice.models.dto.MemberFollowDTO;
import com.bizvane.mktcenterservice.models.dto.MemberUpgradeDto;
import com.bizvane.mktcenterservice.models.dto.RemoteMemberFollowDTO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.text.ParseException;
import java.util.List;

/**
 * @author chen.li
 * @date on 2018/7/13 18:44
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
public interface ActivityUpgradeService {

    /**
     * 查询升级活动列表
     * @param vo
     * @return
     */
    public ResponseData<ActivityVO> getActivityUpgradeList(ActivityVO vo, PageForm pageForm, SysAccountPO stageUser);
    /**
     * 新增会员升级活动
     * @param bo
     * @return
     */
    public ResponseData<Integer> addActivityUpgrade(ActivityBO bo, SysAccountPO stageUser) throws ParseException;
    /**
     * 修改活动
     * @return
     */
    public ResponseData<Integer> updateActivityUpgrade(ActivityBO bo,SysAccountPO stageUser);

    /**
     * 查询活动详情
     * @param 
     * @return
     */
    public ResponseData<ActivityBO> selectActivityUpgradesById(String businessCode);

    /**
     * 执行活动
     * @param vo
     * @return
     */
    public ResponseData<Integer> executeUpgrades(MemberInfoModel vo);
    /**
     * 活动审核
     * @param
     * @return
     */
    public ResponseData<Integer> checkActivityUpgrades(SysCheckPo po, SysAccountPO sysAccountPO);

    /**
     * 付费等级会员退费逻辑
     * @param memberUpgradeDto
     */
    ResponseData<Integer> executeUpgradesRefund(MemberUpgradeDto memberUpgradeDto);

    /**
     * 会员续会奖励
     * @return
     */
    ResponseData memberFollowReward(RemoteMemberFollowDTO dto);
}
