package com.bizvane.mktcenterservice.common;

import com.bizvane.utils.responseinfo.ResponseData;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * @author yifei
 * @since 2022/8/4
 */
@Setter
@Getter
@ToString
public class Result<T> extends ResponseData<T> {
    private static final long serialVersionUID = 8379936992006841441L;

    private Long total;

    private boolean success;

    public Result(){}

    public static <T> Result<T> newResult() {
        return new Result<T>();
    }

    public static <T> Result<T> success(T data,Integer code, String message) {
        Result<T> result = newResult();
        result.setData(data);
        result.setCode(code);
        result.setMessage(message);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success(T data, Long total) {
        Result<T> result = newResult();
        result.setData(data);
        result.setTotal(total);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = newResult();
        result.setData(data);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success() {
        Result<T> result = newResult();
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> failure(String message) {
        Result<T> result = newResult();
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(Integer errorCode, String message) {
        Result<T> result = newResult();
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(T t, Integer errorCode, String message) {
        Result<T> result = newResult();
        result.setData(t);
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

}
