package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道来源类型
 */
@Getter
public enum ContentChannelTriggerTypeEnum {
    /**
     *动作/事件触发地方类型：1.活动，2.领券中心，3，红包膨胀，4。幸运大转盘
     */
    ACTIVITY(1, "活动"),
    GET_COUPON(2, "领券中心"),
    RED_PACKET_EXPAND(3, "红包膨胀"),
    WHEEL_OF_FORTUNE(4, "幸运大转盘");

    private Integer code;
    private String message;

    ContentChannelTriggerTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
