package com.bizvane.mktcenterservice.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.util.Date;
import java.util.List;

/**
 * 秒杀活动详情
 */
@Data
public class SeckillActivityAddResponseVO {
    /**
     * 活动编号
     */
    @ApiModelProperty(value = "活动编号")
    private String activityCode;

    /**
     * 活动名称
     */
    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "活动类型 0每日 1每周 2每月 3自定义日期")
    private Integer activityType;

    /**
     * 活动规则 根据类型设置
     */
    @ApiModelProperty(value = "活动规则 根据类型设置")
    private String activityRule;

    /**
     * 秒杀结束时间
     */
    @ApiModelProperty(value = "秒杀开始时间")
    private Long seckillStartTime;

    /**
     * 秒杀结束时间
     */
    @ApiModelProperty(value = "秒杀结束时间")
    private Long seckillEndTime;

    private String seckillTimeDesc;


    /**
     * 活动状态
     */
    @ApiModelProperty(value = "活动状态")
    private SeckillActivityStatus status;

    /**
     * 活动状态描述
     */
    @ApiModelProperty(value = "活动状态描述")
    private String activityStatusDecr;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String creator;


    /**
     * 是否禁用：1禁用，0未禁用
     */
    @ApiModelProperty(value = "是否禁用：1禁用，0未禁用")
    private Integer disabled;

    /**
     * 活动购买限制/件
     */
    @ApiModelProperty(value = "是否活动购买限制/件")
    private Integer activityPurchaseLimit;

    /**
     * 活动抢购次数
     */
    @ApiModelProperty(value = "是否活动抢购次数")
    private Integer activityCountLimit;

    /**
     * 活动购买限制/件
     */
    @ApiModelProperty(value = "活动购买限制/件")
    private Integer activityPurchase;


    /**
     * 活动抢购次数
     */
    @ApiModelProperty(value = "活动抢购次数")
    private Integer activityCount;


    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间描述")
    private String gmtCreateDesc;

    private Integer version;

    private List<SeckillActivityGoodsDTO> goodsDTOS;

    /**
     * 下一场活动开始日期（2022-07-15）
     */
    @ApiModelProperty(value = "下一场活动开始日期")
    private String nextActivityDate;

    /**
     * 所属品牌id
     */
    @ApiModelProperty(value="所属品牌id")
    private Integer sysBrandId;


    /**
     * 是否展示
     */
    @ApiModelProperty(value="是否展示")
    private Integer isShow;

    /**
     * 品牌Id
     */
    @ApiModelProperty(value="活动列表图片")
    private String activityListImage;


    /**
     * 是否进行中
     */
    @ApiModelProperty(value="是否进行中")
    private Boolean isOpen;

    @Valid
    private List<SeckillActivityCouponDTO> coupons;

}
