package com.bizvane.mktcenterservice.models.activity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author yifei
 * @since 2022/8/4
 */
@Getter
@Setter
@ToString
public class IntegralActivityCouponDTO {
    private Long id;
    /**
     * 兑换券id
     */
    @ApiModelProperty(value = "兑换券id")
    private Long exchangeId;

    /**
     * 券名称
     */
    @ApiModelProperty(value = "券名称")
    private String couponName;

    @ApiModelProperty(value = "兑换券积分")
    private Integer exchangePrice;

    @ApiModelProperty(value = "兑换券现金")
    private BigDecimal exchangeCashPrice;


    @ApiModelProperty(value = "库存数量")
    private Integer stockCount;

    /**
     * 活动积分价格
     */
    @ApiModelProperty(value = "活动积分价格")
    private Long activityPrice;

    /**
     * 活动现金价
     */
    @ApiModelProperty(value = "活动现金价")
    @Digits(integer = 10, fraction = 2, message = "活动现金价整数位最大为10，小数位最大为2")
    private BigDecimal activityCashPrice;

    /**
     * 活动库存
     */
    @ApiModelProperty(value = "活动库存")
    @NotNull(message = "活动库存不能为空")
    @Min(value = 0, message = "活动库存仅支持整数，必须小于等于实际库存")
    private Integer activityStock;

    private Integer deleted;
}
