package com.bizvane.mktcenterservice.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.models.po.CouponEntityPO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2018/12/19 14:21
 */
public interface ActivityPriceService {

    public ResponseData<JSONObject> addActivityPrice(ActivityPriceBO bo, HttpServletRequest request) throws ParseException;
    public ResponseData<JSONObject> updateActivityPrice(ActivityPriceBO bo, HttpServletRequest request) throws ParseException;
    public ResponseData<ActivityPriceBO> selectActivityPrice(Long mktActivityId,HttpServletRequest request);
    public ResponseData<ActivityPrizeBO> selectActivityPrice(String activePriceCode);
    public ResponseData<PageInfo<MktActivityPOWithBLOBs>> selectActivityPriceLists(ActivityPriceParamVO vo, HttpServletRequest request);
    public ResponseData<Integer> stopActivityPrice(MktActivityPOWithBLOBs po, HttpServletRequest request);
    public ResponseData<PageInfo<AnalysisPriceResultVO>> selectAnalysisPrice(ActivityPriceParamVO vo, HttpServletRequest request);
    public ResponseData<PageInfo<MktActivityPrizeRecordPO>> selectPrizePeople(ActivityPriceParamVO vo);
    public ResponseData<String> doVerificationCoupon(ActivityPriceParamVO vo, HttpServletRequest request);
    public ResponseData<String> exportQRCodes(ActivityPriceParamVO vo, HttpServletRequest request, HttpServletResponse response);

    ResponseData<PageInfo<AnalysisPriceResultVO>> selectAnalysisPrizeNew(ActivityPriceParamVO vo, HttpServletRequest request);

//    /**
//     * 获取自提实物相关信息
//     * @param po
//     * @return
//     */
//    ResponseData<MktActivityPrizeInfoBO> getPrizeStorePickUpInfo(MktActivityPrizeRecordPO po);

    /**
     * 门店确认提货
     * @param mktActivityPrizeRecordId
     * @return
     */
    ResponseData pickUpConfirm(Long mktActivityPrizeRecordId);

    /**
     * 获取中奖记录详情
     * @param po
     * @return
     */
    ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(MktActivityPrizeRecordPO po);

    /**
     * 根据中奖记录ID获取自提门店ID集合
     * @param po
     * @return
     */
    ResponseData<List<Long>> selectStoreIds(MktActivityPrizeRecordPO po);

    /**
     * 根据中奖记录ID获取自提门店ID集合
     * @param po
     * @return
     */
    ResponseData<List<Long>> selectStoreIdsByRecordId(MktActivityPrizeRecordPO po);

    /**
     * 获取互动游戏列表
     * @param stageUser
     * @return
     */
    ResponseData selectActivityGameList(SysAccountPO stageUser);

    ResponseData updatePrizeRecordByCouponStatus(@RequestBody CouponEntityPO po);
}
