package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.TaskAwardBO;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnairePrepareDoBO;
import com.bizvane.mktcenterservice.models.bo.TaskQuestionnaireRewardBO;
import com.bizvane.mktcenterservice.models.vo.TaskCallBackVO;
import com.bizvane.mktcenterservice.models.vo.TaskVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.models.auth.In;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: lijc
 * @Time: 2019年11月22日14:26:56
 */
@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/taskQuestionnaireRpc")
public interface TaskQuestionnaireServiceRpc {

    @PostMapping("getTempCodeByTaskId")
    ResponseData<String> getTempCodeByTaskId(@RequestBody TaskVO taskVO);

    @PostMapping("getTaskByTaskId")
    ResponseData<TaskVO> getTaskByTaskId(@RequestBody TaskVO taskVO);

    @PostMapping("doTaskQuestionnaire")
    ResponseData doTaskQuestionnaire(@RequestBody TaskAwardBO bo);

    @PostMapping("getTaskRewardDetail")
    ResponseData<TaskQuestionnaireRewardBO> getTaskRewardDetail(@RequestParam("mktTaskId") Long mktTaskId);


    /**
     * 预执行调查问卷任务
     * @return
     */
    @PostMapping("prepareDoTaskQuestionnaire")
    ResponseData<TaskQuestionnairePrepareDoBO> prepareDoTaskQuestionnaire(@RequestBody TaskAwardBO bo);


    /**
     * 根据问卷code查询是否存在有效调查问卷任务
     */
    @PostMapping("getTaskByTemplateCode")
    ResponseData<Boolean> getTaskByTemplateCode(@RequestParam("templateCode") String templateCode);

    /**
     * 锦泓第三方调查问卷回调接口，用于标记处理状态和奖励发放
     * @anthor shifeng
     * @param taskCallBackVO
     * @return ResponseData
     * 2022-11-6 15:39:13
     */
    @PostMapping("doJhTaskQuestionnaireCallBack")
    ResponseData doJhTaskQuestionnaireCallBack(@RequestBody TaskCallBackVO taskCallBackVO);

}

