package com.bizvane.mktcenterservice.models.activity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.Valid;
import java.util.Date;
import java.util.List;

/**
 * @author yifei
 * @since 2022/8/4
 */
@Getter
@Setter
@ToString
public class IntegralActivityAddResponseVO {
    private Long activityId;

    @ApiModelProperty(name = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "活动类型 0营销活动")
    private Byte activityType ;

    @ApiModelProperty(name = "活动状态 0关闭 1开启")
    private Boolean activityStatus;

    @ApiModelProperty(name = "活动开始时间")
    private Date beginTime;

    @ApiModelProperty(name = "活动结束时间")
    private Date endTime;

    @ApiModelProperty(name = "活动限购 -1 不限购 1 限购")
    private Integer activityPurchaseLimit;

    @ApiModelProperty(name = "活动限购数量限制")
    private Integer activityPurchaseCount ;

    @Valid
    private List<IntegralActivityCouponDTO> coupons;

}
