package com.bizvane.mktcenterservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.CouponIntegralExchangeBO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @Author: lijunwei
 * @Time: 2018/11/23 11:28
 */
public interface ConvertCouponService {

    public ResponseData<PageInfo<MktConvertCouponRecordPO>> getCouponRecordLists(CouponRecordVO vo);

    public ResponseData<CouponIntegralExchangeBO> getConvernCouponLists(CouponRecordVO vo);

    public ResponseData<CouponIntegralExchangeBO> getConvernCouponListsForActivity(CouponRecordVO vo);

    public ResponseData<String> doConvernCoupon(CouponRecordVO vo);

    public void computeIntegralCost(IntegralCouponCostComputeVo vo);

    public ResponseData<PageInfo<MktConvertCouponRecordPO>> getConvernConpouByMember(CouponRecordVO vo);

    public void doExportData(CouponRecordVO vo,HttpServletResponse response) throws IOException;

    public ResponseData doExportData001(CouponRecordVO vo, HttpServletRequest request);

    public ResponseData<CouponIntegralExchangeVO> getCouponAndPriceForActivity(CouponRecordVO vo);

    public ResponseData<CouponIntegralExchangeVO> getCouponAndPrice(CouponRecordVO vo);

    public ResponseData<MktConvertCouponRecordPOWithBLOBs> getConvernConpouDetail(Long convertCouponRecordId);

    public ResponseData validateConvernCoupon(CouponRecordVO vo);

    public ResponseData<MktConvertCouponRecordPO> paySuccess(Long convertCouponRecordId);

    ResponseData<MktGiftBagVO> getGiftBag(Long bizId);


    ResponseData<Boolean> changeStock(List<ChangeExchangeVO> list);

    ResponseData<Boolean> updateExchangeSalesStatus(IntegralActivityVO vo);

    ResponseData<List<MktCouponIntegralExchangeVO>> getExchangeCouponsByIds(List<Long> exchangeIds);

    ResponseData<Boolean> checkActivityPurchase(CouponRecordVO vo);

    ResponseData<List<MktCouponIntegralExchangeVO>> getExchangeCouponsByIdsForActivity(IntegralActivityVO vo);

    /**
     * 分页查询数据
     * @param vo
     * @param offset
     * @param size
     * @return
     */
    List<MktConvertCouponRecordPO> getCouponRecordListsPage(CouponRecordVO vo, Long offset, Long size);
}
