package com.bizvane.mktcenterservice.models.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;

public class ChannelRecordInfoRequestVO {
    /**
     * 内容Id
     */
    private Long mktContentId;

    /**
     * 企业Id
     */
    private Long sysCompanyId;

    /**
     * 品牌Id
     */
    private Long sysBrandId;

    /**
     * 俱乐部选择类型  1-全部 2-指定品牌
     */
    private Integer selectBrandType;

    /**
     * 选择的俱乐部Id
     */
    private Long selectBrandId;

    /**
     * 渠道Id
     */
    private Long mktChannelConfigId;

    /**
     * 投放周期 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    /**
     * 投放周期 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    /**
     * 来源明细 内容名称
     */
    private String contentName;

    /**
     * 来源明细 来源编号
     */
    private String sourceSourceCode;

    /**
     * 来源明细 来源名称
     */
    private String sourceSourceName;

    /**
     * 来源明细 当前页码 前端不传的话，默认值为1
     */
    private Integer sourcePageNum = 1;

    /**
     * 来源明细 每页的数量 前端不传的话，默认值为10
     */
    private Integer sourcePageSize = 10;

    /**
     * 会员明细 会员卡号
     */
    private String cardNo;

    /**
     * 会员明细 会员手机号
     */
    private String phone;

    /**
     * 会员明细 渠道事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
     */
    private Integer actionType;

    /**
     * 会员明细 来源编号
     */
    private String actionSourceCode;

    /**
     * 会员明细 当前页码 前端不传的话，默认值为1
     */
    private Integer actionPageNum = 1;

    /**
     * 会员明细 每页的数量 前端不传的话，默认值为10
     */
    private Integer actionPageSize = 10;

    //以下字段仅用作查询传参用
    private ArrayList<Long> BrandIdList;

    public Long getMktContentId() {
        return mktContentId;
    }

    public void setMktContentId(Long mktContentId) {
        this.mktContentId = mktContentId;
    }

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getSysBrandId() {
        return sysBrandId;
    }

    public void setSysBrandId(Long sysBrandId) {
        this.sysBrandId = sysBrandId;
    }

    public Integer getSelectBrandType() {
        return selectBrandType;
    }

    public void setSelectBrandType(Integer selectBrandType) {
        this.selectBrandType = selectBrandType;
    }

    public Long getSelectBrandId() {
        return selectBrandId;
    }

    public void setSelectBrandId(Long selectBrandId) {
        this.selectBrandId = selectBrandId;
    }

    public Long getMktChannelConfigId() {
        return mktChannelConfigId;
    }

    public void setMktChannelConfigId(Long mktChannelConfigId) {
        this.mktChannelConfigId = mktChannelConfigId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getContentName() {
        return contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public String getSourceSourceCode() {
        return sourceSourceCode;
    }

    public void setSourceSourceCode(String sourceSourceCode) {
        this.sourceSourceCode = sourceSourceCode;
    }

    public String getSourceSourceName() {
        return sourceSourceName;
    }

    public void setSourceSourceName(String sourceSourceName) {
        this.sourceSourceName = sourceSourceName;
    }

    public Integer getSourcePageNum() {
        return sourcePageNum;
    }

    public void setSourcePageNum(Integer sourcePageNum) {
        this.sourcePageNum = sourcePageNum;
    }

    public Integer getSourcePageSize() {
        return sourcePageSize;
    }

    public void setSourcePageSize(Integer sourcePageSize) {
        this.sourcePageSize = sourcePageSize;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getActionType() {
        return actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

    public String getActionSourceCode() {
        return actionSourceCode;
    }

    public void setActionSourceCode(String actionSourceCode) {
        this.actionSourceCode = actionSourceCode;
    }

    public Integer getActionPageNum() {
        return actionPageNum;
    }

    public void setActionPageNum(Integer actionPageNum) {
        this.actionPageNum = actionPageNum;
    }

    public Integer getActionPageSize() {
        return actionPageSize;
    }

    public void setActionPageSize(Integer actionPageSize) {
        this.actionPageSize = actionPageSize;
    }

    public ArrayList<Long> getBrandIdList() {
        return BrandIdList;
    }

    public void setBrandIdList(ArrayList<Long> brandIdList) {
        BrandIdList = brandIdList;
    }
}
