package com.bizvane.mktcenterservice.models.activity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yifei
 * @since 2022/8/4
 */
@Setter
@Getter
@ToString
public class IntegralActivityOrderRecordPO {
    private Long id;

    /**
     * 订单编号
     */
    @ApiModelProperty(value="订单编号")
    private String orderNo;

    /**
     * 商品id
     */
    @ApiModelProperty(value="商品id")
    private Integer goodsId;

    /**
     * 商品编号
     */
    @ApiModelProperty(value="商品编号")
    private String goodsNo;

    /**
     * 商品名称
     */
    @ApiModelProperty(value="商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品类型 0 实体 1 电子券")
    private Integer goodsType;

    /**
     * 订单支付状态 0待支付 1已支付 2 已取消 -1已退款
     */
    @ApiModelProperty(value="订单支付状态 0待支付 1已支付 2 已取消 -1已退款")
    private Integer orderPayStatus;

    /**
     * 下单件数
     */
    @ApiModelProperty(value="下单件数")
    private Integer orderPieceNum;

    /**
     * 下单现金金额
     */
    @ApiModelProperty(value="下单现金金额")
    private BigDecimal orderCashNum;

    /**
     * 下单积分数
     */
    @ApiModelProperty(value="下单积分数")
    private Integer orderIntegralNum;

    /**
     * 下单时间
     */
    @ApiModelProperty(value="下单时间")
    private Date orderTime;

    /**
     * 活动编号
     */
    @ApiModelProperty(value="活动编号")
    private Long activityId;

    private String memberCode;
}
