package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道来源动作类型
 */
@Getter
/**
 * 订单支付枚举
 */
public enum ContentChannelSourceBusinessTypeEnum {
    /**
     *业务类型：0.自定义1.门店来源2.导购来源
     */
    CUSTOMIZE(0, "自定义"),
    STORE(1, "门店来源"),
    GUIDE(2, "导购来源")
    ;

    private Integer code;
    private String message;

    ContentChannelSourceBusinessTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
