package com.bizvane.mktcenterservice.common;

import lombok.Getter;

/**
 * 渠道来源动作类型
 */
@Getter
/**
 * 订单支付枚举
 */
public enum ContentChannelSourceActionTypeEnum {
    /**
     *动作/事件类型：1.浏览，2.注册，3绑定，4点亮俱乐部
     */
    PV(1, "浏览"),
    REGISTER(2, "注册"),
    BIND(3, "绑定"),
    JOIN_CLUB(4, "点亮俱乐部")
    ;

    private Integer code;
    private String message;

    ContentChannelSourceActionTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
