package com.bizvane.mktcenterservice.models.newmkt;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @description: 活动日业绩requestVo
 * @author: Liu Xinpeng
 * @create: 2020-08-13 10:05
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ActivityDaySalesRequestVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 活动类型 OD_CONSUMPTION:消费活动  RECEIVE_COUPON:领券活动
     */
    private String activityType;

    /**
     * 粒度
     * 1 - 按日
     * 2 - 按月
     * 3 - 按年
     */
    private String particleSize;

    /**
     * 活动开始时间
     */
    private String startTime;

    /**
     * 活动时间
     */
    private String endTime;
}