package com.bizvane.mktcenterservice.models.vo;

import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.Data;

import java.util.Date;
import java.util.Map;

@Data
public class ActivityRegistrationSinupRecordVo {
    //活动id
    private Long mktActivityId;
    //是否会员
    private boolean member;
    //是否签到
    private boolean signin;
    //所属店铺
    private String storeName;
    //报名来源
    private Integer signupSource;
    /**
     * 如果是别人帮自己报名的, 报名的人的姓名
     */
    private String name;
    /**
     * 如果是别人帮自己报名的, 报名的人的openid
     */
    private String wxOpenId;
    /**
     * 如果是别人帮自己报名的, 报名的人的电话
     */
    private String phone;
    //报名会员code
    private String memberCode;

    private String propertyJson;
    //报名时间
    private Date signupDate;
    //帮报名会员code
    private String helpMemberCode;
    //帮报名姓名
    private String helpName;
    //帮报名手机号
    private String helpPhone;

    //赠送优惠券(张)
    private Integer sendCouponNumber;

    public Map<String, Object> getProperties() {
        return JacksonUtil.json2Map(propertyJson);
    }

    public String getSignupSource() {
        switch (this.signupSource) {
            case 0:
                return "自己报名";
            case 1:
                return "他人帮报名";
            case 2:
                return "签到报名";
            default:
                return null;
        }
    }
}
