package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityRegistrationBO;
import com.bizvane.mktcenterservice.models.bo.TMktActivitySignup;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhaoxh
 */
@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityRegistrationRpc")
public interface ActivityRegistrationServiceRpc {
    /**
     * 查询活动详情
     */
    @PostMapping("/detail")
    ResponseData<ActivityRegistrationBO> getActivityRegistrationDetail(@RequestParam("activityCode") String activityCode);

    @PostMapping("/signup")
    ResponseData<Object> signup(@RequestBody TMktActivitySignup activitySignup);

    @PostMapping("/signuped")
    ResponseData<Boolean> signuped(@RequestParam String activityCode, @RequestParam("memberCode") String memberCode);

    @PostMapping("/getByActivityCodeAndPhone")
    ResponseData<List<TMktActivitySignup>> getByActivityCodeAndPhone(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone);

    @PostMapping("/signupHistory")
    ResponseData<List<SignupHistory>> signupHistory(@RequestParam("memberCode") String memberCode);

    @PostMapping("/signin")
    ResponseData<Object> signin(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone);
}
