package com.bizvane.mktcenter.feign.vo.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class QueryFortuneWheelWinRecordRespVO {

    @ApiModelProperty(value = "会员卡号")
    private String cardNo;

    @ApiModelProperty(value = "会员手机号")
    private String phone;

    @ApiModelProperty("参与时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime joinTime;

    @ApiModelProperty("奖品名称")
    private String prizeName;

    @ApiModelProperty("奖品类型")
    private Integer prizeType;

    @ApiModelProperty("奖项等级")
    private Integer prizeLevel;

    @ApiModelProperty("收货人")
    private String consigneeName;

    @ApiModelProperty("收货人电话")
    private String consigneeMobile;

    @ApiModelProperty("收货人加密电话")
    private String consigneeMobileEncrypt;

    @ApiModelProperty("收货省份")
    private String consigneeProvince;

    @ApiModelProperty("收货城市")
    private String consigneeCity;

    @ApiModelProperty("收货行政区")
    private String consigneeDistrict;

    @ApiModelProperty("收货具体地址")
    private String consigneeAddress;
}
