package com.bizvane.mktcenter.feign.vo.resp;

import com.bizvane.message.feign.vo.mail.MsgMailTempDetailResponseVO;
import com.bizvane.message.feign.vo.sms.template.MsgSmsTempDetailResponseVO;
import com.bizvane.message.feign.vo.subscribe.MsgWxMiniProTempDetailResponseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class QueryDetailBatchSendMessageRespVO {

    @ApiModelProperty(value = "营销 - 消息群发系统编号code")
    private String mktBatchSendMessageCode;

    @ApiModelProperty(value = "群发消息名称")
    private String sendMessageName;

    @ApiModelProperty(value = "会员条件类型  1全部会员 2会员分组")
    private Integer mbrConditionType;

    @ApiModelProperty(value = "关联的会员分组系统code")
    private String mbrGroupDefCode;

    @ApiModelProperty(value = "关联的会员分组系统名称")
    private String mbrGroupDefName;

    @ApiModelProperty(value = "执行时间类型 1立即发送 2定时发送")
    private Integer exeTimeType;

    @ApiModelProperty(value = "定时执行时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime exeTime;

    @ApiModelProperty(value = "消息群发任务类型 1微信小程序订阅消息2短信消息3站内消息")
    private Integer sendMessageType;

    @ApiModelProperty(value = "消息模板code")
    private String messageTemplateCode;

    @ApiModelProperty(value = "消息模板名称")
    private String messageTemplateName;

    @ApiModelProperty(value = "任务状态 1待执行，2执行中，3已结束，4已禁用")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人编号")
    private String createUserCode;

    @ApiModelProperty(value = "创建人名称")
    private String createUserName;

    @ApiModelProperty(value = "小程序订阅消息模板信息")
    private MsgWxMiniProTempDetailResponseVO msgWxMiniProTempDetailResponseVO;

    @ApiModelProperty(value = "站内消息模板信息")
    private MsgMailTempDetailResponseVO msgMailTempDetailResponseVO;

    @ApiModelProperty(value = "短信模块")
    private MsgSmsTempDetailResponseVO smsTempDetailResponseVO;

}
