package com.bizvane.mktcenter.feign.vo.resp;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class ActivityAnalysisVO {

    @ApiModelProperty(value = "活动系统编号code")
    private String mktActivityCode;

    @ApiModelProperty(value = "活动编号")
    private String activityNo;

    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "活动状态：1待执行，2执行中，3已结束，4已禁用")
    private Integer activityStatus;

    @ApiModelProperty(value = "是否长期：1是，0否")
    private Integer longTerm;

    @ApiModelProperty(value = "活动已进行时长")
    private String activityDuration;

    @ApiModelProperty(value = "活动开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "活动结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modifiedDate;

    @ApiModelProperty(value = "发放优惠券张数")
    private Integer couponNum;

    @ApiModelProperty(value = "发放外部券张数")
    private Integer outCouponNum;

    @ApiModelProperty(value = "已核销优惠券张数")
    private Integer usedCouponNum;

    @ApiModelProperty(value = "优惠券核销率")
    private String couponUsedRate;

    @ApiModelProperty(value = "券收益")
    private String couponIncome;

    @ApiModelProperty(value = "发放积分数")
    private Integer integralNum;
}
