package com.bizvane.mktcenter.feign.api.mobile;

import com.bizvane.mktcenter.feign.vo.req.MktActivityVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileCheckActivityStatusReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryActivityDetailReqVO;
import com.bizvane.mktcenter.feign.vo.req.mobile.MobileQueryActivityListReqVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.ActivityAndTaskStatusRespVO;
import com.bizvane.mktcenter.feign.vo.resp.mobile.MobileQueryActivityListRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "${feign.client.mktcenter.name}",path = "${feign.client.mktcenter.path}/mobile/activity")
public interface MobileMktActivityFeign {

    @ApiModelProperty(value = "获取活动列表")
    @PostMapping("/getMobileActivityList")
    ResponseData<List<MobileQueryActivityListRespVO>> getMobileActivityList(@RequestBody MobileQueryActivityListReqVO reqVO);

    @ApiModelProperty(value = "获取活动详情")
    @PostMapping("/getDetail")
    ResponseData<MktActivityVO> getDetail(@RequestBody MobileQueryActivityDetailReqVO reqVO);

    @ApiModelProperty(value = "检查活动状态")
    @PostMapping("/checkStatus")
    ResponseData<ActivityAndTaskStatusRespVO> checkStatus(@RequestBody MobileCheckActivityStatusReqVO reqVO);

}
